######## Set working directory
setwd("E:/St Andrews/St Andrews/NC crows/safekeeping II/data")
getwd()

####### Library loading
library(lme4)
library(DHARMa)


####### Data importing
data_raw<-read.table("Klump_etal_safekeepingII_Experiment2.csv", head=T, sep=",")
str(data_raw)

####### data preping
#level of safekeeping: RCuration C=storage underfoot and in holes is safe; #mode of safekeeping: RCuration D= storage in holes is safe
data_raw$RCuration_final_C<-1
data_raw$RCuration_final_C[data_raw$final_safekeeping=="ground" | data_raw$final_safekeeping=="log"]<-0
data_raw$RCuration_initial_C<-1
data_raw$RCuration_initial_C[data_raw$initial_safekeeping=="ground" | data_raw$initial_safekeeping=="log"]<-0

data_raw$RCuration_final_D<-1
data_raw$RCuration_final_D[data_raw$final_safekeeping=="ground" | data_raw$final_safekeeping=="log" | data_raw$final_safekeeping=="foot"]<-0
data_raw$RCuration_initial_D<-1
data_raw$RCuration_initial_D[data_raw$initial_safekeeping=="ground" | data_raw$initial_safekeeping=="log"| data_raw$initial_safekeeping=="foot"]<-0

#define holesize: L=large, S=small
data_raw$holesize<-"L"
data_raw$holesize[data_raw$hole==3 |data_raw$hole==6 |data_raw$hole==9 |data_raw$hole==12 |data_raw$hole==15 |data_raw$hole==18 |data_raw$hole==21 |data_raw$hole==24 |data_raw$hole==27 |data_raw$hole==30 |data_raw$hole==33 |data_raw$hole==36]<-"S"

#define bait: LS=spider in large hole, SM= meat in small hole, LM= meat in large hole
data_raw$bait2<-"LS"
data_raw$bait2[data_raw$bait=="M"&data_raw$holesize=="S"]<-"SM"
data_raw$bait2[data_raw$bait=="M"&data_raw$holesize=="L"]<-"LM"

#set trial, hole, safekeeping and bait2 as factors
data_raw$trial<-as.factor(data_raw$trial)
data_raw$hole<-as.factor(data_raw$hole)
data_raw$RCuration_initial_C<-as.factor(data_raw$RCuration_initial_C)
data_raw$RCuration_final_C<-as.factor(data_raw$RCuration_final_C)
data_raw$RCuration_initial_D<-as.factor(data_raw$RCuration_initial_D)
data_raw$RCuration_final_D<-as.factor(data_raw$RCuration_final_D)
data_raw$bait2<-as.factor(data_raw$bait2)

str(data_raw)

######does bait dropping influence safekeeping?####
##safekeeping ~ Bait on ground
Drop0 <- glmer(RCuration_final_C ~1 + (1|BirdID), family="binomial", data=data_raw)
Drop <- glmer(RCuration_final_C ~bait_on_ground + (1|BirdID), family="binomial", data=data_raw)
anova(Drop0, Drop) #p<0.001 => use data_final
simulationDrop<-simulateResiduals(fittedModel = Drop)
testResiduals(simulationDrop)

###yes => exclude cases when bait was on ground
data_final <- data_raw[which(data_raw$bait_on_ground=="n"),]

str(data_final)



###split dataset into crow and human made
crow<-data_final[-which(data_final$trial=="matchedstick"|data_final$trial=="matchedhook"),]
human<-data_final[-which(data_final$trial=="100sticks"|data_final$trial=="desmanthus"),]
allsticks<-data_final[-which(data_final$trial=="desmanthus"|data_final$trial=="matchedhook"),]
allhooks<-data_final[-which(data_final$trial=="100sticks"|data_final$trial=="matchedstick"),]
mstick_desmantus<-data_final[-which(data_final$trial=="matchedhook"|data_final$trial=="100sticks"),]

###MODELS####
###ecologically valid comparison (Treatments 2.A vs. 2.B)
# Model #1, level of safekeeping
toolcc<-glmer(RCuration_final_C~tool+(1|bait2)+(1|BirdID),family="binomial", data=crow)
summary(toolcc)
nullcc<-glmer(RCuration_final_C~1+(1|bait2)+(1|BirdID),family="binomial", data=crow)
anova(toolcc,nullcc) #p=0.02,Chi2: 5.47,df1
simulation_toolcc<-simulateResiduals(fittedModel = toolcc)
testResiduals(simulation_toolcc)

coeftbl_toolcc <- as.data.frame(coef(summary(toolcc)))
with(coeftbl_toolcc,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


#Model #2, mode of safekeeping
toolcd<-glmer(RCuration_final_D~tool+(1|bait2)+(1|BirdID),family="binomial", data=crow)
summary(toolcd)
nullcd<-glmer(RCuration_final_D~1+(1|bait2)+(1|BirdID),family="binomial", data=crow)
anova(toolcd,nullcd) #<0.001,Chi2: 19.78,df1
simulation_toolcd<-simulateResiduals(fittedModel = toolcd)
testResiduals(simulation_toolcd)

coeftbl_toolcd <- as.data.frame(coef(summary(toolcd)))
with(coeftbl_toolcd,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


###tool type (Treatments 2.C vs 2.D)
#Model #3, level of safekeeping
toolhc<-glmer(RCuration_final_C~tool+(1|bait2)+(1|BirdID),family="binomial", data=human)
summary(toolhc)
nullhc<-glmer(RCuration_final_C~1+(1|bait2)+(1|BirdID),family="binomial", data=human)
anova(toolhc,nullhc) #p=0.31,Chi2:1.04,df1
simulation_toolhc<-simulateResiduals(fittedModel = toolhc)
testResiduals(simulation_toolhc)

coeftbl_toolhc <- as.data.frame(coef(summary(toolhc)))
with(coeftbl_toolhc,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


#Model #4, mode of safekeeping
toolhd<-glmer(RCuration_final_D~tool+(1|bait2)+(1|BirdID),family="binomial", data=human)
summary(toolhd)
nullhd<-glmer(RCuration_final_D~1+(1|bait2)+(1|BirdID),family="binomial", data=human)
anova(toolhd,nullhd) #p=0.007,Chi2:7.24,df1
simulation_toolhd<-simulateResiduals(fittedModel = toolhd)
testResiduals(simulation_toolhd)

coeftbl_toolhd <- as.data.frame(coef(summary(toolhd)))
with(coeftbl_toolhd,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


###compare Treatments 2.B and 2.C
#Model #5, level of safekeeping
tool_testc<-glmer(RCuration_final_C~tool+(1|bait2)+(1|BirdID),family="binomial", data=mstick_desmantus)
summary(tool_testc)
null_testc<-glmer(RCuration_final_C~1+(1|bait2)+(1|BirdID),family="binomial", data=mstick_desmantus)
anova(tool_testc,null_testc) #p=0.35,Chi2: 0.87,df1
simulation_tool_testc<-simulateResiduals(tool_testc)
testResiduals(simulation_tool_testc)

coeftbl_tool_testc <- as.data.frame(coef(summary(tool_testc)))
with(coeftbl_tool_testc,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


#Model #6, mode of safekeeping
tool_testd<-glmer(RCuration_final_D~tool+(1|bait2)+(1|BirdID),family="binomial", data=mstick_desmantus)
summary(tool_testd)
null_testd<-glmer(RCuration_final_D~1+(1|bait2)+(1|BirdID),family="binomial", data=mstick_desmantus)
anova(tool_testd,null_testd) #p=0.04,Chi2: 4.11,df1
simulation_tool_testd<-simulateResiduals(tool_testd)
testResiduals(simulation_tool_testd)

coeftbl_tool_testd <- as.data.frame(coef(summary(tool_testd)))
with(coeftbl_tool_testd,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


###tool material (Treatments 2.A vs 2.C)
#Model #7, level of safekeeping
materialallsc<-glmer(RCuration_final_C~material+(1|bait2)+(1|BirdID),family="binomial", data=allsticks)
summary(materialallsc)
nullallsc<-glmer(RCuration_final_C~1+(1|bait2)+(1|BirdID),family="binomial", data=allsticks)
anova(materialallsc, nullallsc)#p=0.33,Chi2:0.94,df1
simulation_materialallsc<-simulateResiduals(materialallsc)
testResiduals(simulation_materialallsc)

coeftbl_materialallsc <- as.data.frame(coef(summary(materialallsc)))
with(coeftbl_materialallsc,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


#Model #8, mode of safekeeping
materialallsd<-glmer(RCuration_final_D~material+(1|bait2)+(1|BirdID),family="binomial", data=allsticks)
summary(materialallsd)
nullallsd<-glmer(RCuration_final_D~1+(1|bait2)+(1|BirdID),family="binomial", data=allsticks)
anova(materialallsd, nullallsd)#p=0.79,Chi2:0.07,df1
simulation_materialallsd<-simulateResiduals(materialallsd)
testResiduals(simulation_materialallsd)

coeftbl_materialallsd <- as.data.frame(coef(summary(materialallsd)))
with(coeftbl_materialallsd,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


###manufacture effort (Treatments 2.B vs. 2.D)
#Model #9, level of safekeeping
makerallhc<-glmer(RCuration_final_C~maker+(1|bait2)+(1|BirdID),family="binomial", data=allhooks)
summary(makerallhc)
nullallhc<-glmer(RCuration_final_C~1+(1|bait2)+(1|BirdID),family="binomial", data=allhooks)
anova(makerallhc,nullallhc) #p=0.81,Chi2:0.06,df:1
simulation_makerallhc<-simulateResiduals(makerallhc)
testResiduals(simulation_makerallhc)

coeftbl_makerallhc <- as.data.frame(coef(summary(makerallhc)))
with(coeftbl_makerallhc,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


#Model #10, mode of safekeeping
makerallhd<-glmer(RCuration_final_D~maker+(1|bait2)+(1|BirdID),family="binomial", data=allhooks)
summary(makerallhd)
nullallhd<-glmer(RCuration_final_D~1+(1|bait2)+(1|BirdID),family="binomial", data=allhooks)
anova(makerallhd,nullallhd) #p=0.86,Chi2:0.03,df:1
simulation_makerallhd<-simulateResiduals(makerallhd)
testResiduals(simulation_makerallhd)

coeftbl_makerallhd <- as.data.frame(coef(summary(makerallhd)))
with(coeftbl_makerallhd,
     +      Estimate + outer(`Std. Error`, c(lower=-1, upper=1)) * sqrt(qchisq(0.95, 1)))


